#ifndef COLLISION_H
#define COLLISION_H

#include <time.h>
#include "../common/vector.h"
#include "../common/matrix.h"
#include "../common/misc.h"
#include "simulation.h"
#include "solvers.h"
#include "../render/intersect/sphere.h"
#include "../common/debug.h"
#include "../common/colors.h"
#include "../parse/parser.h"
#include "../common/list.h"


void fill_pqp_matrix(PQP_REAL pqp[3][3], double rot[3][3]);
void add_pqp_data(object *obj);
void resolve_plane_collision(object *obj1, object *obj2, PQP_CollideResult *collision);
void resolve_sphere_collision(object *obj1, object *obj2, PQP_CollideResult *collision);
void collide_objects(object *obj1, object *obj2);
void check_collisions(object *obj1, int obj_num);
char touching_other_sphere(double new_radius, vector *new_position);
void adjust_tessellation(int delta);

#endif